#include <stdlib.h>
#include <stdio.h>
#include <GL/glut.h>

int CurrentNum = 0;
const int MaxNum = 10;

const double Xmin = -0.1, Xmax = 1.1;
const double Ymin = -0.1, Ymax = 1.1;

int spalvinam=1;

void myKeyboardFunc(unsigned char key, int x, int y) {
  switch (key) {
    case ' ':
      CurrentNum = (CurrentNum+1)%MaxNum;
      glutPostRedisplay();
    break;
    case 27:
      exit(1);
    break;
  }
}

void drawFractal(int num)
{
  if (num==0) {
    glBegin(GL_POLYGON);
      glVertex3f(0, 0, 0);
      glVertex3f(0, 1, 0);
      glVertex3f(1, 0, 0);
    glEnd();
  }
  else {
    glPushMatrix();
    glPushMatrix();
    //glPushMatrix();
        
    glScalef(0.5, 0.5, 1);
    glRotatef(90, 0, 0, 1);
    glTranslatef(0, -1, 0);
    if (spalvinam==1) {
      glColor3f(1, 0, 0);
      spalvinam = 0;
      drawFractal(num - 1);
      spalvinam = 1;
    } 
    else 
      drawFractal(num - 1);
         
    glPopMatrix();
    glScalef(0.5, 0.5, 1);
    glRotatef(270, 0, 0, 1);
    glTranslatef(-1, 1, 0);
    if (spalvinam==1) {
      glColor3f(0, 1, 0);
      spalvinam = 0;
      drawFractal(num - 1);
      spalvinam = 1;
    }
    else 
      drawFractal(num - 1);
        
    glPopMatrix();
    glScalef(0.5, 0.5, 1);
    glRotatef(180, 0, 1, 0);
    glTranslatef(-2, 2, 0);
    glRotatef(-90, 0, 0, 1);
    if (spalvinam==1) {
      glColor3f(0, 0, 1);
      spalvinam = 0;
      drawFractal(num - 1);
      spalvinam = 1;
    }
    else 
      drawFractal(num - 1);
  }
}

void drawScene(void) {
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  glColor3f(1, 1, 1);		
  
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
    
  drawFractal(CurrentNum);

  glFlush();
}


void resizeWindow(int w, int h) {
  double scale, center;
  double windowXmin, windowXmax, windowYmin, windowYmax;

  glViewport(0, 0, w, h);

  w = (w==0) ? 1 : w;
  h = (h==0) ? 1 : h;
  if ((Xmax-Xmin)/w < (Ymax-Ymin)/h) {
    scale = ((Ymax-Ymin)/h)/((Xmax-Xmin)/w);
	center = (Xmax+Xmin)/2;
	windowXmin = center - (center-Xmin)*scale;
	windowXmax = center + (Xmax-center)*scale;
	windowYmin = Ymin;
	windowYmax = Ymax;
  }
  else {
    scale = ((Xmax-Xmin)/w)/((Ymax-Ymin)/h);
	center = (Ymax+Ymin)/2;
	windowYmin = center - (center-Ymin)*scale;
	windowYmax = center + (Ymax-center)*scale;
	windowXmin = Xmin;
	windowXmax = Xmax;
  }

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glOrtho(windowXmin, windowXmax, windowYmin, windowYmax, -1, 1);
}

int main( int argc, char** argv ) {
  glutInit(&argc,argv);

  glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB | GLUT_DEPTH );

  glutInitWindowPosition(20, 60);
  glutInitWindowSize(500, 500);
  glutCreateWindow("SimpleDraw - Press space bar to toggle images");

  glEnable(GL_DEPTH_TEST);

  glutKeyboardFunc(myKeyboardFunc);

  glutReshapeFunc(resizeWindow);

  glutDisplayFunc(drawScene);

  fprintf(stdout, "Press space bar for the next step; escape button to quit.\n");
	
  glutMainLoop();
}

